/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.enchant;

import com.nenio.enchant.GridEffectHandler;
import com.nenio.oasis.OasisStore;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public final class OasisEffectHandler {
    private static final class_5321<class_1887> OASIS_KEY = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)class_2960.method_60655((String)"farmerenchants", (String)"oasis"));

    private OasisEffectHandler() {
    }

    public static void register() {
        UseBlockCallback.EVENT.register(OasisEffectHandler::onUseBlock);
    }

    private static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        int newly;
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 tool = player.method_6047();
        if (!(tool.method_7909() instanceof class_1794)) {
            return class_1269.field_5811;
        }
        if (!OasisEffectHandler.hasOasis(world, tool)) {
            return class_1269.field_5811;
        }
        class_2338 clickedPos = hit.method_17777();
        class_2680 clickedState = world.method_8320(clickedPos);
        if (!clickedState.method_27852(class_2246.field_10362)) {
            return class_1269.field_5811;
        }
        class_1799 off = player.method_6079();
        boolean seeds = OasisEffectHandler.isPlantableSeed(off.method_7960() ? null : off.method_7909());
        boolean airAbove = world.method_8320(clickedPos.method_10084()).method_26215();
        if (seeds && airAbove && OasisStore.get((class_3218)world).contains(clickedPos)) {
            return class_1269.field_5811;
        }
        boolean[] changed = new boolean[]{false};
        GridEffectHandler.forEach(world, clickedPos, tool, gridPos -> {
            class_2680 s = world.method_8320(gridPos);
            if (!s.method_27852(class_2246.field_10362)) {
                return;
            }
            OasisStore store = OasisStore.get((class_3218)world);
            if (store.contains((class_2338)gridPos)) {
                return;
            }
            store.add((class_2338)gridPos);
            OasisEffectHandler.setMoisture(world, gridPos, s, 7);
            changed[0] = true;
        });
        if (!changed[0]) {
            return class_1269.field_5811;
        }
        if (!player.method_31549().field_7477 && tool.method_7963() && (newly = OasisStore.get((class_3218)world).drainLastAdded()) > 0) {
            tool.method_7970(3 * newly, (class_1309)player, class_1304.field_6173);
        }
        return class_1269.field_5812;
    }

    public static boolean hasOasis(class_1937 world, class_1799 tool) {
        class_2378 enchReg = world.method_30349().method_30530(class_7924.field_41265);
        class_6880 oasis = enchReg.method_46746(OASIS_KEY).orElse(null);
        if (oasis == null) {
            return false;
        }
        class_9304 comp = (class_9304)tool.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        return comp.method_57536(oasis) > 0;
    }

    private static void setMoisture(class_1937 world, class_2338 pos, class_2680 current, int value) {
        class_2758 M = class_2344.field_11009;
        if (!current.method_28498((class_2769)M)) {
            return;
        }
        int v = Math.max(0, Math.min(7, value));
        if ((Integer)current.method_11654((class_2769)M) != v) {
            world.method_8652(pos, (class_2680)current.method_11657((class_2769)M, (Comparable)Integer.valueOf(v)), 3);
        }
    }

    public static int tryApplyOasisOn(class_1937 world, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return 0;
        }
        class_3218 sw = (class_3218)world;
        class_2680 s = world.method_8320(pos);
        if (!s.method_27852(class_2246.field_10362)) {
            return 0;
        }
        OasisStore store = OasisStore.get(sw);
        if (store.contains(pos)) {
            return 0;
        }
        store.add(pos);
        OasisEffectHandler.setMoisture(world, pos, s, 7);
        return 1;
    }

    private static boolean isPlantableSeed(class_1792 item) {
        if (item == null) {
            return false;
        }
        return item == class_1802.field_8317 || item == class_1802.field_8309 || item == class_1802.field_8179 || item == class_1802.field_8567 || item == class_1802.field_42711 || item == class_1802.field_43195;
    }
}

