/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.blockentity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reborncore.common.blockentity.MachineBaseBlockEntity;
import reborncore.common.util.NBTSerializable;

public class FluidConfiguration
implements NBTSerializable {
    private static final class_9139<ByteBuf, Map<class_2350, FluidConfig>> SIDE_MAP_PACKET_CODEC = class_9135.method_56377(HashMap::new, (class_9139)class_2350.field_48450, FluidConfig.PACKET_CODEC);
    public static final class_9139<ByteBuf, FluidConfiguration> PACKET_CODEC = class_9139.method_56436(SIDE_MAP_PACKET_CODEC, FluidConfiguration::getSideMap, (class_9139)class_9135.field_48547, FluidConfiguration::autoInput, (class_9139)class_9135.field_48547, FluidConfiguration::autoOutput, FluidConfiguration::new);
    Map<class_2350, FluidConfig> sideMap;
    boolean input;
    boolean output;

    public FluidConfiguration() {
        this.sideMap = new HashMap<class_2350, FluidConfig>();
        Arrays.stream(class_2350.values()).forEach(facing -> this.sideMap.put((class_2350)facing, new FluidConfig((class_2350)facing)));
    }

    public FluidConfiguration(class_11368 view) {
        this.sideMap = new HashMap<class_2350, FluidConfig>();
        this.read(view);
    }

    private FluidConfiguration(Map<class_2350, FluidConfig> sideMap, boolean input, boolean output) {
        this.sideMap = sideMap;
        this.input = input;
        this.output = output;
    }

    public FluidConfig getSideDetail(class_2350 side) {
        if (side == null) {
            return this.sideMap.get(class_2350.field_11043);
        }
        return this.sideMap.get(side);
    }

    public List<FluidConfig> getAllSides() {
        return new ArrayList<FluidConfig>(this.sideMap.values());
    }

    public Map<class_2350, FluidConfig> getSideMap() {
        return this.sideMap;
    }

    public void updateFluidConfig(FluidConfig config) {
        FluidConfig toEdit = this.sideMap.get(config.side);
        toEdit.ioConfig = config.ioConfig;
    }

    public void update(MachineBaseBlockEntity machineBase) {
        if (!this.input && !this.output) {
            return;
        }
        if (machineBase.getTank() == null || machineBase.method_10997().method_8510() % (long)machineBase.slotTransferSpeed() != 0L) {
            return;
        }
        for (class_2350 facing : class_2350.values()) {
            FluidConfig fluidConfig = this.getSideDetail(facing);
            if (fluidConfig == null || !fluidConfig.getIoConfig().isEnabled()) continue;
            @Nullable Storage<FluidVariant> tank = this.getTank(machineBase, facing);
            if (this.autoInput() && fluidConfig.getIoConfig().isInsert()) {
                StorageUtil.move(tank, (Storage)machineBase.getTank(), fv -> true, (long)machineBase.fluidTransferAmount().getRawValue(), null);
            }
            if (!this.autoOutput() || !fluidConfig.getIoConfig().isExtract()) continue;
            StorageUtil.move((Storage)machineBase.getTank(), tank, fv -> true, (long)machineBase.fluidTransferAmount().getRawValue(), null);
        }
    }

    @Nullable
    private Storage<FluidVariant> getTank(MachineBaseBlockEntity machine, class_2350 facing) {
        class_2338 pos = machine.method_11016().method_10093(facing);
        return (Storage)FluidStorage.SIDED.find(machine.method_10997(), pos, (Object)facing.method_10153());
    }

    public boolean autoInput() {
        return this.input;
    }

    public boolean autoOutput() {
        return this.output;
    }

    public void setInput(boolean input) {
        this.input = input;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    @Override
    public void write(class_11372 view) {
        Arrays.stream(class_2350.values()).forEach(facing -> this.sideMap.get(facing).write(view.method_71461("side_" + facing.ordinal())));
        view.method_71472("input", this.input);
        view.method_71472("output", this.output);
    }

    @Override
    public void read(@NotNull class_11368 view) {
        this.sideMap.clear();
        Arrays.stream(class_2350.values()).forEach(facing -> view.method_71420("side_" + facing.ordinal()).ifPresent(config -> this.sideMap.put((class_2350)facing, new FluidConfig((class_11368)config))));
        this.input = view.method_71433("input", false);
        this.output = view.method_71433("output", false);
    }

    public static class FluidConfig
    implements NBTSerializable {
        public static final class_9139<ByteBuf, FluidConfig> PACKET_CODEC = class_9139.method_56435((class_9139)class_2350.field_48450, FluidConfig::getSide, ExtractConfig.PACKET_CODEC, FluidConfig::getIoConfig, FluidConfig::new);
        class_2350 side;
        ExtractConfig ioConfig;

        public FluidConfig(class_2350 side) {
            this.side = side;
            this.ioConfig = ExtractConfig.ALL;
        }

        public FluidConfig(class_2350 side, ExtractConfig ioConfig) {
            this.side = side;
            this.ioConfig = ioConfig;
        }

        public FluidConfig(class_11368 view) {
            this.read(view);
        }

        public class_2350 getSide() {
            return this.side;
        }

        public ExtractConfig getIoConfig() {
            return this.ioConfig;
        }

        @Override
        public void write(class_11372 view) {
            view.method_71465("side", this.side.ordinal());
            view.method_71465("config", this.ioConfig.ordinal());
        }

        @Override
        public void read(@NotNull class_11368 view) {
            this.side = class_2350.values()[view.method_71424("side", 0)];
            this.ioConfig = ExtractConfig.values()[view.method_71424("config", 0)];
        }
    }

    public static enum ExtractConfig {
        NONE(false, false),
        INPUT(false, true),
        OUTPUT(true, false),
        ALL(true, true);

        public static final class_9139<ByteBuf, ExtractConfig> PACKET_CODEC;
        boolean extract;
        boolean insert;

        private ExtractConfig(boolean extract, boolean insert) {
            this.extract = extract;
            this.insert = insert;
        }

        public boolean isExtract() {
            return this.extract;
        }

        public boolean isInsert() {
            return this.insert;
        }

        public boolean isEnabled() {
            return this.extract || this.insert;
        }

        public ExtractConfig getNext() {
            int i = this.ordinal() + 1;
            if (i >= ExtractConfig.values().length) {
                i = 0;
            }
            return ExtractConfig.values()[i];
        }

        static {
            PACKET_CODEC = class_9135.field_49675.method_56432(integer -> ExtractConfig.values()[integer], Enum::ordinal);
        }
    }
}

