/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.init.ModDataComponents;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.IFilter;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public abstract class UpgradeBase<T>
implements IUpgrade<T> {
    public UpgradeManager upgradeManager;
    public int dataHolderSlot;
    public Point openTabSize;

    public UpgradeBase(UpgradeManager manager, int dataHolderSlot, Point openTabSize) {
        this.upgradeManager = manager;
        this.dataHolderSlot = dataHolderSlot;
        this.openTabSize = openTabSize;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public int getDataHolderSlot() {
        return this.dataHolderSlot;
    }

    @Override
    public boolean isTabOpened() {
        return (Boolean)this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot).method_58695(ModDataComponents.TAB_OPEN, (Object)false);
    }

    public class_1799 getDataHolderStack() {
        return this.upgradeManager.getUpgradesHandler().getStackInSlot(this.dataHolderSlot);
    }

    @Override
    public Point getTabSize() {
        if (this.isTabOpened()) {
            UpgradeBase upgradeBase = this;
            if (upgradeBase instanceof IFilter) {
                IFilter filter = (IFilter)((Object)upgradeBase);
                int rowCount = (int)Math.ceil((double)filter.getFilterSlotCount() / 3.0);
                return new Point(this.openTabSize.x(), this.openTabSize.y() - 18 * (3 - rowCount));
            }
            return this.openTabSize;
        }
        return new Point(24, 24);
    }

    public void updateDataHolderUnchecked(Consumer<class_1799> updater) {
        class_1799 dataHolderStack = this.getDataHolderStack().method_7972();
        if (dataHolderStack.method_7960()) {
            return;
        }
        updater.accept(dataHolderStack);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public <D> void updateDataHolderUnchecked(class_9331<D> dataKey, D value) {
        class_1799 dataHolderStack = this.getDataHolderStack().method_7972();
        if (dataHolderStack.method_7960()) {
            return;
        }
        dataHolderStack.method_57379(dataKey, value);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public void setCooldown(int cooldown) {
        class_1799 dataHolderStack = this.getDataHolderStack().method_7972();
        dataHolderStack.method_57379(ModDataComponents.COOLDOWN, (Object)cooldown);
        this.getUpgradeManager().getUpgradesHandler().setStackInSlot(this.getDataHolderSlot(), dataHolderStack);
    }

    public int getCooldown() {
        return (Integer)this.getDataHolderStack().method_58695(ModDataComponents.COOLDOWN, (Object)100);
    }

    public boolean hasCooldown() {
        return this.getDataHolderStack().method_57826(ModDataComponents.COOLDOWN);
    }
}

