/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.display;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface Display
extends DisplaySpec {
    public static Codec<Display> codec() {
        return DisplaySerializerRegistry.getInstance().codec();
    }

    public static class_9139<class_9129, Display> streamCodec() {
        return DisplaySerializerRegistry.getInstance().streamCodec();
    }

    public List<EntryIngredient> getInputEntries();

    default public List<InputIngredient<EntryStack<?>>> getInputIngredients(@Nullable class_1703 menu, @Nullable class_1657 player) {
        return CollectionUtils.mapIndexed(this.getInputEntries(), InputIngredient::of);
    }

    public List<EntryIngredient> getOutputEntries();

    default public List<EntryIngredient> getRequiredEntries() {
        return this.getInputEntries();
    }

    public CategoryIdentifier<?> getCategoryIdentifier();

    public Optional<class_2960> getDisplayLocation();

    @Nullable
    public DisplaySerializer<? extends Display> getSerializer();

    @Override
    @ApiStatus.NonExtendable
    default public Display provideInternalDisplay() {
        return this;
    }

    @Override
    @ApiStatus.NonExtendable
    default public Collection<class_2960> provideInternalDisplayIds() {
        Optional<class_2960> location = this.getDisplayLocation();
        if (location.isPresent()) {
            return Collections.singletonList(location.get());
        }
        return Collections.emptyList();
    }
}

