/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.graphics;

import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.computer.app.HomeControl;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerSelectionList;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageHomeControl;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

public class HomeControlGraphics
extends DisplayableProgram<HomeControl> {
    public HomeControlGraphics(HomeControl program) {
        super(program, 200, 100);
        this.setScene(new Home(this));
    }

    public static class Home
    extends Scene {
        private final HomeControlGraphics graphics;
        private final ComputerSelectionList<DeviceItem> devices;
        private final ComputerButton turnOnAllButton;
        private final ComputerButton turnOffAllButton;
        private final ComputerButton infoButton;

        public Home(HomeControlGraphics graphics) {
            this.graphics = graphics;
            this.devices = this.addWidget(new ComputerSelectionList(graphics.getWidth() - 10, graphics.getHeight() - 30, 25, 100, 16));
            ((HomeControl)graphics.getProgram()).findDevices().forEach(device -> this.devices.method_25396().add(new DeviceItem((IHomeControlDevice)device)));
            this.turnOnAllButton = this.addWidget(new ComputerButton(60, 14, graphics.translation("turn_on_all"), btn -> Network.getPlay().sendToServer((Object)new MessageHomeControl.UpdateAll(true))));
            this.turnOnAllButton.setTextColour(-13147337);
            this.turnOnAllButton.setTextHighlightColour(-13147337);
            this.turnOnAllButton.setOutlineColour(-14540251);
            this.turnOnAllButton.setBackgroundHighlightColour(-13423059);
            this.turnOffAllButton = this.addWidget(new ComputerButton(60, 14, graphics.translation("turn_off_all"), btn -> Network.getPlay().sendToServer((Object)new MessageHomeControl.UpdateAll(false))));
            this.turnOffAllButton.setTextColour(-10143432);
            this.turnOffAllButton.setTextHighlightColour(-10143432);
            this.turnOffAllButton.setOutlineColour(-14540251);
            this.turnOffAllButton.setBackgroundHighlightColour(-13423059);
            this.infoButton = this.addWidget(new ComputerButton(13, 14, (class_2561)class_2561.method_43470((String)"i"), btn -> graphics.setScene(new Info(graphics))));
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.devices.method_48229(contentStart + 5, contentTop + 25);
            this.turnOnAllButton.method_48229(contentStart + 5, contentTop + 3);
            this.turnOffAllButton.method_48229(contentStart + 5 + this.turnOnAllButton.method_25368() + 2, contentTop + 3);
            this.infoButton.method_48229(contentStart + this.graphics.getWidth() - 5 - this.infoButton.method_25368(), contentTop + 3);
        }

        @Override
        public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            graphics.method_25294(0, 0, this.graphics.getWidth(), 20, -14277082);
        }
    }

    private static class DeviceItem
    extends class_4280.class_4281<DeviceItem> {
        private final IHomeControlDevice device;
        private final ComputerButton button;

        public DeviceItem(IHomeControlDevice device) {
            this.device = device;
            this.button = new ComputerButton(50, 14, (class_2561)class_2561.method_43470((String)"Toggle"), btn -> Network.getPlay().sendToServer((Object)new MessageHomeControl.Toggle(this.device.getDevicePos())));
            this.button.setBackgroundHighlightColour(-13423059);
            this.updateButtonLabel();
        }

        private void updateButtonLabel() {
            this.button.method_25355(this.device.isDeviceEnabled() ? class_5244.field_24332 : class_5244.field_24333);
            this.button.setTextColour(this.device.isDeviceEnabled() ? -13147337 : -10143432);
            this.button.setTextHighlightColour(this.device.isDeviceEnabled() ? -13147337 : -10143432);
        }

        public void method_49568(class_332 $$0, int $$1, int $$2, int $$3, int $$4, int $$5, int $$6, int $$7, boolean $$8, float $$9) {
            super.method_49568($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7, $$8, $$9);
        }

        public void method_25343(class_332 graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
            this.updateButtonLabel();
            graphics.method_25294(left, top, left + rowWidth, top + rowHeight, -12107714);
            graphics.method_51439(class_310.method_1551().field_1772, this.device.getDeviceName(), left + 5, top + 4, -14540251, false);
            this.button.method_48229(left + rowWidth - this.button.method_25368() - 1, top + 1);
            this.button.method_25394(graphics, mouseX, mouseY, partialTick);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.button.method_25402(mouseX, mouseY, button);
            return true;
        }

        public class_2561 method_37006() {
            return this.device.getDeviceName();
        }
    }

    public static class Info
    extends Scene {
        private final HomeControlGraphics graphics;
        private final ComputerButton backButton;
        private final class_2561 infoText;

        public Info(HomeControlGraphics graphics) {
            this.graphics = graphics;
            this.backButton = this.addWidget(new ComputerButton(14, 14, (class_2561)class_2561.method_43470((String)"<"), btn -> graphics.setScene(new Home(graphics))));
            this.infoText = graphics.translation("info");
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.backButton.method_48229(contentStart + 5, contentTop + 3);
        }

        @Override
        public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            graphics.method_25294(0, 0, this.graphics.getWidth(), 20, -14277082);
            graphics.method_65179(class_310.method_1551().field_1772, (class_5348)this.infoText, 5, 25, this.graphics.getWidth() - 10, -12107714);
        }
    }
}

