/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.rei;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import reborncore.common.crafting.RebornRecipe;
import reborncore.common.fluid.container.FluidInstance;
import techreborn.recipe.recipes.FluidReplicatorRecipe;

public class FluidReplicatorRecipeDisplay
implements Display {
    public static final DisplaySerializer<FluidReplicatorRecipeDisplay> SERIALIZER = DisplaySerializer.of((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("category").forGetter(d -> d.category.getIdentifier().toString()), (App)EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(FluidReplicatorRecipeDisplay::getInputEntries), (App)EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(FluidReplicatorRecipeDisplay::getOutputEntries), (App)class_2960.field_25139.optionalFieldOf("location").forGetter(FluidReplicatorRecipeDisplay::getDisplayLocation), (App)FluidInstance.CODEC.optionalFieldOf("fluidInstance").forGetter(d -> Optional.ofNullable(d.fluidInstance)), (App)Codec.INT.fieldOf("energy").forGetter(FluidReplicatorRecipeDisplay::getEnergy), (App)Codec.INT.fieldOf("time").forGetter(FluidReplicatorRecipeDisplay::getTime)).apply((Applicative)instance, FluidReplicatorRecipeDisplay::new)), (class_9139)class_9139.method_64265((class_9139)class_9135.field_48554, d -> d.category.getIdentifier().toString(), (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), FluidReplicatorRecipeDisplay::getInputEntries, (class_9139)EntryIngredient.streamCodec().method_56433(class_9135.method_56363()), FluidReplicatorRecipeDisplay::getOutputEntries, (class_9139)class_9135.method_56382((class_9139)class_2960.field_48267), FluidReplicatorRecipeDisplay::getDisplayLocation, (class_9139)class_9135.method_56382((class_9139)FluidInstance.PACKET_CODEC), d -> Optional.ofNullable(d.fluidInstance), (class_9139)class_9135.field_49675, FluidReplicatorRecipeDisplay::getEnergy, (class_9139)class_9135.field_49675, FluidReplicatorRecipeDisplay::getTime, FluidReplicatorRecipeDisplay::new));
    private final CategoryIdentifier<?> category;
    private final Optional<class_2960> location;
    private final List<EntryIngredient> inputs;
    private final List<EntryIngredient> outputs;
    private final FluidInstance fluidInstance;
    private final int energy;
    private final int time;

    public FluidReplicatorRecipeDisplay(String category, List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_2960> location, Optional<FluidInstance> fluidInstance, int energy, int time) {
        this.category = CategoryIdentifier.of((String)category);
        this.inputs = inputs;
        this.outputs = outputs;
        this.location = location;
        this.fluidInstance = fluidInstance.orElse(null);
        this.energy = energy;
        this.time = time;
    }

    public FluidReplicatorRecipeDisplay(class_8786<RebornRecipe> entry) {
        FluidReplicatorRecipe recipe = (FluidReplicatorRecipe)entry.comp_1933();
        this.category = CategoryIdentifier.of((class_2960)Objects.requireNonNull(class_7923.field_41188.method_10221((Object)recipe.method_17716())));
        this.location = Optional.of(entry.comp_1932().method_29177());
        this.inputs = CollectionUtils.map(recipe.ingredients(), ing -> EntryIngredients.ofItemStacks((Collection)ing.getPreviewStacks()));
        this.fluidInstance = recipe.fluid();
        this.outputs = this.fluidInstance == null ? Collections.emptyList() : Collections.singletonList(EntryIngredients.of((class_3611)this.fluidInstance.fluid(), (long)this.fluidInstance.getAmount().getRawValue()));
        this.energy = recipe.power();
        this.time = recipe.time();
    }

    public FluidInstance getFluidInstance() {
        return this.fluidInstance;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getTime() {
        return this.time;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputs;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.category;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.location;
    }

    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}

