/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.inventory;

import fuzs.illagerinvasion.init.ModItems;
import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.init.ModSoundEvents;
import fuzs.illagerinvasion.world.item.enchantment.ImbuingEnchantmentLevel;
import fuzs.puzzleslib.api.container.v1.QuickMoveRuleSet;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_5244;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import org.jetbrains.annotations.Nullable;

public class ImbuingMenu
extends class_1703 {
    private final class_1263 input;
    private final class_1731 output = new class_1731();
    private final class_3914 access;
    public final class_3915 imbuingState;

    public ImbuingMenu(int containerId, class_1661 inventory) {
        this(containerId, inventory, class_3914.field_17304);
    }

    public ImbuingMenu(int containerId, class_1661 inventory, class_3914 access) {
        super((class_3917)ModRegistry.IMBUING_MENU_TYPE.comp_349(), containerId);
        int i;
        this.access = access;
        this.imbuingState = this.method_17362(class_3915.method_17403());
        this.input = new class_1277(3){

            public void method_5431() {
                super.method_5431();
                ImbuingMenu.this.method_7609((class_1263)this);
            }
        };
        this.method_7621(new class_1735(this, this.input, 0, 26, 54){

            public boolean method_7680(class_1799 itemStack) {
                return itemStack.method_31574(class_1802.field_8598);
            }
        });
        this.method_7621(new class_1735(this, this.input, 1, 80, 54){

            public boolean method_7680(class_1799 itemStack) {
                return class_1890.method_58117((class_1799)itemStack);
            }
        });
        this.method_7621(new class_1735(this, this.input, 2, 134, 54){

            public boolean method_7680(class_1799 itemStack) {
                return itemStack.method_41406(ModItems.HALLOWED_GEM_ITEM);
            }
        });
        this.method_7621(new class_1735((class_1263)this.output, 3, 80, 14){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public boolean method_7674(class_1657 playerEntity) {
                return true;
            }

            public void method_7667(class_1657 playerEntity, class_1799 itemStack) {
                ImbuingMenu.this.input.method_5447(0, class_1799.field_8037);
                ImbuingMenu.this.input.method_5447(1, class_1799.field_8037);
                class_1799 stack = ImbuingMenu.this.input.method_5438(2);
                stack.method_7934(1);
                ImbuingMenu.this.input.method_5447(2, stack);
                ImbuingMenu.this.imbuingState.method_17404(ImbuingState.ALL_GOOD.ordinal());
                playerEntity.method_5783((class_3414)ModSoundEvents.SORCERER_COMPLETE_CAST_SOUND_EVENT.comp_349(), 1.0f, 1.0f);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)inventory, i, 8 + i * 18, 142));
        }
        this.method_7609(this.input);
    }

    public boolean method_7597(class_1657 player) {
        return ImbuingMenu.method_17695((class_3914)this.access, (class_1657)player, (class_2248)((class_2248)ModRegistry.IMBUING_TABLE_BLOCK.comp_349()));
    }

    public void method_7609(class_1263 inventory) {
        if (inventory == this.input) {
            this.access.method_17393((level, blockPos) -> this.updateResult());
        }
        super.method_7609(inventory);
    }

    protected void updateResult() {
        class_1799 itemStack;
        class_1799 bookItem = this.input.method_5438(0);
        class_1799 imbuingItem = this.input.method_5438(1);
        class_1799 gemItem = this.input.method_5438(2);
        ImbuingState imbuingState = this.selectImbuingState(bookItem, imbuingItem, gemItem);
        this.imbuingState.method_17404(imbuingState.ordinal());
        if (imbuingState == ImbuingState.ALL_GOOD) {
            class_9304 bookEnchantments = class_1890.method_57532((class_1799)bookItem);
            class_6880 enchantment = (class_6880)bookEnchantments.method_57534().iterator().next();
            itemStack = imbuingItem.method_7972();
            int imbuedLevel = bookEnchantments.method_57536(enchantment) + 1;
            itemStack.method_7978(enchantment, imbuedLevel);
        } else {
            itemStack = class_1799.field_8037;
        }
        this.output.method_5447(0, itemStack);
    }

    protected ImbuingState selectImbuingState(class_1799 bookItem, class_1799 imbuingItem, class_1799 gemItem) {
        if (bookItem.method_7960()) {
            return ImbuingState.ENCHANTED_BOOK_MISSING;
        }
        if (gemItem.method_7960()) {
            return ImbuingState.HALLOWED_GEM_MISSING;
        }
        if (imbuingItem.method_7960()) {
            return ImbuingState.ITEM_MISSING;
        }
        class_9304 bookEnchantments = class_1890.method_57532((class_1799)bookItem);
        if (bookEnchantments.method_57541() != 1) {
            return ImbuingState.TOO_MANY_ENCHANTMENTS;
        }
        class_6880 enchantment = (class_6880)bookEnchantments.method_57534().iterator().next();
        int bookEnchantmentLevel = bookEnchantments.method_57536(enchantment);
        if (!ImbuingEnchantmentLevel.isSupportedByImbuing((class_6880<class_1887>)enchantment) || bookEnchantmentLevel >= ImbuingEnchantmentLevel.getImbuingMaxEnchantmentLevel((class_6880<class_1887>)enchantment)) {
            return ImbuingState.INVALID_ENCHANTMENT;
        }
        class_9304 itemEnchantments = class_1890.method_57532((class_1799)imbuingItem);
        int itemEnchantmentLevel = itemEnchantments.method_57536(enchantment);
        if (itemEnchantmentLevel == 0) {
            return ImbuingState.ENCHANTMENTS_NOT_MATCHING;
        }
        if (itemEnchantmentLevel != bookEnchantmentLevel) {
            return ImbuingState.LEVELS_NOT_EQUAL;
        }
        return ImbuingState.ALL_GOOD;
    }

    public ImbuingState getImbuingState() {
        return ImbuingState.values()[this.imbuingState.method_17407()];
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return QuickMoveRuleSet.of((class_1703)this, (x$0, x$1, x$2, x$3) -> this.method_7616(x$0, x$1, x$2, x$3)).addContainerSlotRule(new int[]{0, 2, 1}).addInventoryRules().addInventoryCompartmentRules().quickMoveStack(player, index);
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.access.method_17393((level, blockPos) -> this.method_7607(player, this.input));
    }

    public static enum ImbuingState {
        ALL_GOOD(null),
        ENCHANTED_BOOK_MISSING("container.imbue.enchantedBookMissing"){

            @Override
            public class_2561 getComponent() {
                return class_2561.method_43469((String)this.translationKey, (Object[])new Object[]{class_1802.field_8598.method_63680()});
            }
        }
        ,
        ITEM_MISSING(null),
        HALLOWED_GEM_MISSING("container.imbue.hallowedGemMissing"){

            @Override
            public class_2561 getComponent() {
                return class_2561.method_43469((String)this.translationKey, (Object[])new Object[]{((class_1792)ModItems.HALLOWED_GEM_ITEM.comp_349()).method_63680()});
            }
        }
        ,
        TOO_MANY_ENCHANTMENTS("container.imbue.tooManyEnchantments"),
        INVALID_ENCHANTMENT("container.imbue.invalidEnchantment"),
        ENCHANTMENTS_NOT_MATCHING("container.imbue.enchantmentsNotMatching"),
        LEVELS_NOT_EQUAL("container.imbue.levelsNotEqual");

        @Nullable
        final String translationKey;

        private ImbuingState(String translationKey) {
            this.translationKey = translationKey;
        }

        public class_2561 getComponent() {
            return this.translationKey != null ? class_2561.method_43471((String)this.translationKey) : class_5244.field_39003;
        }

        public boolean showTooltip() {
            return this != ALL_GOOD && this != ITEM_MISSING;
        }
    }
}

