/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public interface INetworkObject {
    public void encode(ByteBuf var1);

    public void decode(ByteBuf var1);

    public static <T extends INetworkObject> T decodeToInstance(T obj, ByteBuf inputByteBuf) {
        obj.decode(inputByteBuf);
        return obj;
    }

    @Contract(value="_, null -> false; _, !null -> true")
    default public boolean writeOptional(ByteBuf outputByteBuf, Object value) {
        boolean isNull = value != null;
        outputByteBuf.writeBoolean(isNull);
        return isNull;
    }

    @Nullable
    default public <T> T readOptional(ByteBuf inputByteBuf, Supplier<T> decoder) {
        return inputByteBuf.readBoolean() ? (T)decoder.get() : null;
    }

    default public void readOptional(ByteBuf inputByteBuf, Runnable decoder) {
        if (inputByteBuf.readBoolean()) {
            decoder.run();
        }
    }

    default public void writeString(String inputString, ByteBuf outputByteBuf) {
        INetworkObject.writeStringStatic(inputString, outputByteBuf);
    }

    public static void writeStringStatic(String inputString, ByteBuf outputByteBuf) {
        byte[] bytes = inputString.getBytes(StandardCharsets.UTF_8);
        outputByteBuf.writeShort(bytes.length);
        outputByteBuf.writeBytes(bytes);
    }

    default public String readString(ByteBuf inputByteBuf) {
        return INetworkObject.readStringStatic(inputByteBuf);
    }

    public static String readStringStatic(ByteBuf inputByteBuf) {
        int length = inputByteBuf.readUnsignedShort();
        return inputByteBuf.readSlice(length).toString(StandardCharsets.UTF_8);
    }

    default public void writeCollection(ByteBuf outputByteBuf, Collection<?> collection) {
        outputByteBuf.writeInt(collection.size());
        this.writeFixedLengthCollection(outputByteBuf, collection);
    }

    default public void writeFixedLengthCollection(ByteBuf outputByteBuf, Collection<?> collection) {
        for (Object item : collection) {
            Codec codec = Codec.getCodec(item.getClass());
            codec.encode.accept(item, outputByteBuf);
        }
    }

    default public <TCollection extends Collection<T>, T> TCollection readCollection(ByteBuf inputByteBuf, TCollection collection, Supplier<T> innerValueConstructor) {
        int size = inputByteBuf.readInt();
        Codec codec = null;
        for (int i = 0; i < size; ++i) {
            Object item = innerValueConstructor.get();
            if (codec == null) {
                codec = Codec.getCodec(item.getClass());
            }
            item = codec.decode.apply(item, inputByteBuf);
            collection.add(item);
        }
        return collection;
    }

    default public <TMap extends Map<K, V>, K, V> TMap readMap(ByteBuf inputByteBuf, TMap map, Supplier<K> keySupplier, Supplier<V> valueSupplier) {
        ArrayList entryList = new ArrayList();
        this.readCollection(inputByteBuf, entryList, () -> new AbstractMap.SimpleEntry(keySupplier.get(), valueSupplier.get()));
        for (Map.Entry entry : entryList) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static class Codec {
        private static final ConcurrentMap<Class<?>, Codec> CODEC_MAP = new ConcurrentHashMap<Class<?>, Codec>(){
            {
                this.put(Integer.class, new Codec((obj, outByteBuff) -> outByteBuff.writeInt(((Integer)obj).intValue()), (obj, inByteBuff) -> inByteBuff.readInt()));
                this.put(Boolean.class, new Codec((obj, outByteBuff) -> outByteBuff.writeBoolean(((Boolean)obj).booleanValue()), (obj, inByteBuff) -> inByteBuff.readBoolean()));
                this.put(String.class, new Codec((obj, outByteBuff) -> INetworkObject.writeStringStatic((String)obj, outByteBuff), (obj, inByteBuff) -> INetworkObject.readStringStatic(inByteBuff)));
                this.put(INetworkObject.class, new Codec(INetworkObject::encode, INetworkObject::decodeToInstance));
                this.put(Map.Entry.class, new Codec((obj, outByteBuff) -> {
                    Map.Entry entry = (Map.Entry)obj;
                    Codec.getCodec(entry.getKey().getClass()).encode.accept(entry.getKey(), (ByteBuf)outByteBuff);
                    Codec.getCodec(entry.getValue().getClass()).encode.accept(entry.getValue(), (ByteBuf)outByteBuff);
                }, (obj, inByteBuff) -> {
                    Map.Entry entry = (Map.Entry)obj;
                    return new AbstractMap.SimpleEntry<Object, Object>(Codec.getCodec(entry.getKey().getClass()).decode.apply(entry.getKey(), (ByteBuf)inByteBuff), Codec.getCodec(entry.getValue().getClass()).decode.apply(entry.getValue(), (ByteBuf)inByteBuff));
                }));
            }
        };
        public final BiConsumer<Object, ByteBuf> encode;
        public final BiFunction<Object, ByteBuf, Object> decode;

        public <T> Codec(BiConsumer<T, ByteBuf> encode, BiFunction<T, ByteBuf, T> decode) {
            this.encode = encode;
            this.decode = decode;
        }

        public static <T> Codec getCodec(Class<T> clazz) {
            return CODEC_MAP.computeIfAbsent(clazz, classToAdd -> {
                for (Map.Entry entry : CODEC_MAP.entrySet()) {
                    if (!((Class)entry.getKey()).isAssignableFrom((Class<?>)classToAdd)) continue;
                    return (Codec)entry.getValue();
                }
                throw new AssertionError((Object)("Class has no compatible codec: " + classToAdd.getSimpleName()));
            });
        }
    }
}

