/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.parsers;

import com.mojang.brigadier.StringReader;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.ColorNode;
import eu.pb4.placeholders.api.node.parent.FormattingNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.impl.textparser.TextParserImpl;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_5251;

public class LegacyFormattingParser
implements NodeParser {
    public static NodeParser COLORS = new LegacyFormattingParser(true, (class_124[])Arrays.stream(class_124.values()).filter(x -> !x.method_543()).toArray(class_124[]::new));
    public static NodeParser BASE_COLORS = new LegacyFormattingParser(false, (class_124[])Arrays.stream(class_124.values()).filter(x -> !x.method_543()).toArray(class_124[]::new));
    public static NodeParser ALL = new LegacyFormattingParser(true, class_124.values());
    private final Char2ObjectOpenHashMap<class_124> map = new Char2ObjectOpenHashMap();
    private final boolean allowRgb;

    public LegacyFormattingParser(boolean allowRgb, class_124 ... allowedFormatting) {
        this.allowRgb = allowRgb;
        for (class_124 formatting : allowedFormatting) {
            this.map.put(formatting.method_36145(), (Object)formatting);
        }
    }

    public boolean allowRGB() {
        return this.allowRgb;
    }

    public Collection<class_124> formatting() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    @Override
    public TextNode[] parseNodes(TextNode input) {
        return this.parseNodes(input, new ArrayList<TextNode>());
    }

    public TextNode[] parseNodes(TextNode input, List<TextNode> nextNodes) {
        if (input instanceof LiteralNode) {
            LiteralNode literalNode = (LiteralNode)input;
            return this.parseLiteral(literalNode, nextNodes);
        }
        if (input instanceof TranslatedNode) {
            TranslatedNode translatedNode = (TranslatedNode)input;
            return new TextNode[]{translatedNode.transform(this)};
        }
        if (input instanceof ParentTextNode) {
            ParentTextNode parentTextNode = (ParentTextNode)input;
            return this.parseParents(parentTextNode);
        }
        return new TextNode[]{input};
    }

    private TextNode[] parseParents(ParentTextNode parentTextNode) {
        ArrayList<TextNode> list = new ArrayList<TextNode>();
        if (parentTextNode.getChildren().length > 0) {
            ArrayList<TextNode> nodes = new ArrayList<TextNode>(List.of(parentTextNode.getChildren()));
            while (!nodes.isEmpty()) {
                list.add(TextNode.asSingle(this.parseNodes(nodes.remove(0), nodes)));
            }
        }
        return new TextNode[]{parentTextNode.copyWith(list.toArray(TextParserImpl.CASTER), (NodeParser)this)};
    }

    private TextNode[] parseLiteral(LiteralNode literalNode, List<TextNode> nexts) {
        StringBuilder builder = new StringBuilder();
        StringReader reader = new StringReader(literalNode.value());
        while (reader.canRead(2)) {
            char i = reader.read();
            if (i == '\\') {
                i = reader.read();
                builder.append('\\');
                builder.append(i);
            } else if (i == '&') {
                class_124 x;
                i = reader.read();
                if (this.allowRgb && i == '#' && reader.canRead(6)) {
                    int start = reader.getCursor();
                    try {
                        StringBuilder builder1 = new StringBuilder();
                        for (int z = 0; z < 6; ++z) {
                            builder1.append(reader.read());
                        }
                        int rgb = Integer.parseInt(builder1.toString(), 16);
                        ArrayList<TextNode> list = new ArrayList<TextNode>();
                        list.addAll(nexts);
                        nexts.clear();
                        TextNode base = TextNode.asSingle(this.parseLiteral(new LiteralNode(reader.getRemaining()), list));
                        list.add(0, base);
                        return new TextNode[]{new LiteralNode(builder.toString()), new ColorNode(list.toArray(TextParserImpl.CASTER), class_5251.method_27717((int)rgb))};
                    }
                    catch (Throwable builder1) {
                        reader.setCursor(start);
                    }
                }
                if ((x = (class_124)this.map.get(i)) != null) {
                    ArrayList<TextNode> list = new ArrayList<TextNode>();
                    list.addAll(nexts);
                    nexts.clear();
                    TextNode base = TextNode.asSingle(this.parseLiteral(new LiteralNode(reader.getRemaining()), list));
                    list.add(0, base);
                    return new TextNode[]{new LiteralNode(builder.toString()), new FormattingNode(list.toArray(TextParserImpl.CASTER), x)};
                }
                builder.append('&');
            }
            builder.append(i);
        }
        return new TextNode[]{literalNode};
    }
}

