/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.redstone.rail;

import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.MinecartPassBlock;
import net.minecraft.class_1269;
import net.minecraft.class_1688;
import net.minecraft.class_1696;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class ControllerRailBlock
extends class_2241
implements IWrenchable,
MinecartPassBlock {
    public static final class_2754<class_2768> SHAPE = class_2741.field_12542;
    public static final class_2746 BACKWARDS = class_2746.method_11825((String)"backwards");
    public static final class_2758 POWER = class_2741.field_12511;
    private static final class_2470[] WRENCH_ROTATION = new class_2470[]{class_2470.field_11463, class_2470.field_11464, class_2470.field_11465};
    public static final MapCodec<ControllerRailBlock> CODEC = ControllerRailBlock.method_54094(ControllerRailBlock::new);

    public ControllerRailBlock(class_4970.class_2251 properties) {
        super(true, properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWER, (Comparable)Integer.valueOf(0))).method_11657((class_2769)BACKWARDS, (Comparable)Boolean.valueOf(false))).method_11657(SHAPE, (Comparable)class_2768.field_12665)).method_11657((class_2769)field_27096, (Comparable)Boolean.valueOf(false)));
    }

    public static int getWireColor(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int tintIndex) {
        return class_2457.method_10487((int)(pos != null && world != null ? (Integer)state.method_11654((class_2769)class_2741.field_12511) : 0));
    }

    public static class_2382 getAccelerationVector(class_2680 state) {
        class_2350 pointingTo = ControllerRailBlock.getPointingTowards(state);
        return (ControllerRailBlock.isStateBackwards(state) ? pointingTo.method_10153() : pointingTo).method_62675();
    }

    private static class_2350 getPointingTowards(class_2680 state) {
        return switch ((class_2768)state.method_11654(SHAPE)) {
            case class_2768.field_12666, class_2768.field_12674 -> class_2350.field_11039;
            case class_2768.field_12667 -> class_2350.field_11034;
            case class_2768.field_12668 -> class_2350.field_11035;
            default -> class_2350.field_11043;
        };
    }

    protected class_2680 method_9475(class_1937 world, class_2338 pos, class_2680 state, boolean p_208489_4_) {
        class_2680 updatedState = super.method_9475(world, pos, state, p_208489_4_);
        if (updatedState.method_11654(SHAPE) == state.method_11654(SHAPE)) {
            return updatedState;
        }
        class_2680 reversedUpdatedState = updatedState;
        if (ControllerRailBlock.getPointingTowards(state).method_10166() != ControllerRailBlock.getPointingTowards(updatedState).method_10166()) {
            for (boolean opposite : Iterate.trueAndFalse) {
                class_2350 offset = ControllerRailBlock.getPointingTowards(updatedState);
                if (opposite) {
                    offset = offset.method_10153();
                }
                for (class_2338 adjPos : Iterate.hereBelowAndAbove(pos.method_10093(offset))) {
                    class_2680 adjState = world.method_8320(adjPos);
                    if (!adjState.method_27852((class_2248)AllBlocks.CONTROLLER_RAIL) || ControllerRailBlock.getPointingTowards(adjState).method_10166() != offset.method_10166() || adjState.method_11654((class_2769)BACKWARDS) == reversedUpdatedState.method_11654((class_2769)BACKWARDS)) continue;
                    reversedUpdatedState = (class_2680)reversedUpdatedState.method_28493((class_2769)BACKWARDS);
                }
            }
        }
        if (reversedUpdatedState != updatedState) {
            world.method_8501(pos, reversedUpdatedState);
        }
        return reversedUpdatedState;
    }

    private static void decelerateCart(class_2338 pos, class_1688 cart) {
        class_243 diff = VecHelper.getCenterOf((class_2382)pos).method_1020(cart.method_19538());
        cart.method_18800(diff.field_1352 / 16.0, 0.0, diff.field_1350 / 16.0);
        if (cart instanceof class_1696) {
            class_1696 fme = (class_1696)cart;
            fme.field_54300 = class_243.field_1353;
        }
    }

    private static boolean isStableWith(class_2680 testState, class_1922 world, class_2338 pos) {
        return ControllerRailBlock.method_16361((class_1922)world, (class_2338)pos.method_10074()) && (!((class_2768)testState.method_11654(SHAPE)).method_11897() || ControllerRailBlock.method_16361((class_1922)world, (class_2338)pos.method_10093(ControllerRailBlock.getPointingTowards(testState))));
    }

    public class_2680 method_9605(class_1750 p_196258_1_) {
        class_2350 direction = p_196258_1_.method_8042();
        class_2680 base = super.method_9605(p_196258_1_);
        return (class_2680)(base == null ? this.method_9564() : base).method_11657((class_2769)BACKWARDS, (Comparable)Boolean.valueOf(direction.method_10171() == class_2350.class_2352.field_11056));
    }

    public class_2769<class_2768> method_9474() {
        return SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> p_206840_1_) {
        p_206840_1_.method_11667(new class_2769[]{SHAPE, POWER, BACKWARDS, field_27096});
    }

    @Override
    public void onMinecartPass(class_2680 state, class_1937 world, class_2338 pos, class_1688 cart) {
        class_243 motion;
        if (world.field_9236) {
            return;
        }
        class_243 accelerationVec = class_243.method_24954((class_2382)ControllerRailBlock.getAccelerationVector(state));
        double targetSpeed = cart.method_7504((class_3218)world) * (double)((Integer)state.method_11654((class_2769)POWER)).intValue() / 15.0;
        if (cart instanceof class_1696) {
            class_1696 fme = (class_1696)cart;
            fme.field_54300 = new class_243(accelerationVec.field_1352, 0.0, accelerationVec.field_1350);
        }
        if (((motion = cart.method_18798()).method_1026(accelerationVec) >= 0.0 || motion.method_1027() < 1.0E-4) && targetSpeed > 0.0) {
            cart.method_18799(accelerationVec.method_1021(targetSpeed));
        } else {
            ControllerRailBlock.decelerateCart(pos, cart);
        }
    }

    protected void method_9477(class_2680 state, class_1937 world, class_2338 pos, class_2248 block) {
        int newPower = this.calculatePower(world, pos);
        if ((Integer)state.method_11654((class_2769)POWER) != newPower) {
            this.placeAndNotify((class_2680)state.method_11657((class_2769)POWER, (Comparable)Integer.valueOf(newPower)), pos, world);
        }
    }

    private int calculatePower(class_1937 world, class_2338 pos) {
        class_2338 testPos;
        int i;
        int newPower = world.method_49804(pos);
        if (newPower != 0) {
            return newPower;
        }
        int forwardDistance = 0;
        int backwardsDistance = 0;
        class_2338 lastForwardRail = pos;
        class_2338 lastBackwardsRail = pos;
        int forwardPower = 0;
        int backwardsPower = 0;
        for (i = 0; i < 15 && (testPos = this.findNextRail(lastForwardRail, (class_1922)world, false)) != null; ++i) {
            ++forwardDistance;
            lastForwardRail = testPos;
            forwardPower = world.method_49804(testPos);
            if (forwardPower != 0) break;
        }
        for (i = 0; i < 15 && (testPos = this.findNextRail(lastBackwardsRail, (class_1922)world, true)) != null; ++i) {
            ++backwardsDistance;
            lastBackwardsRail = testPos;
            backwardsPower = world.method_49804(testPos);
            if (backwardsPower != 0) break;
        }
        if (forwardDistance > 8 && backwardsDistance > 8) {
            return 0;
        }
        if (backwardsPower == 0 && forwardDistance <= 8) {
            return forwardPower;
        }
        if (forwardPower == 0 && backwardsDistance <= 8) {
            return backwardsPower;
        }
        if (backwardsPower != 0 && forwardPower != 0) {
            return class_3532.method_15384((double)((double)(backwardsPower * forwardDistance + forwardPower * backwardsDistance) / (double)(forwardDistance + backwardsDistance)));
        }
        return 0;
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1937 world = context.method_8045();
        if (world.field_9236) {
            return class_1269.field_5812;
        }
        class_2338 pos = context.method_8037();
        for (class_2470 testRotation : WRENCH_ROTATION) {
            class_2680 testState = this.method_9598(state, testRotation);
            if (!ControllerRailBlock.isStableWith(testState, (class_1922)world, pos)) continue;
            this.placeAndNotify(testState, pos, world);
            return class_1269.field_5812;
        }
        class_2680 testState = (class_2680)state.method_11657((class_2769)BACKWARDS, (Comparable)Boolean.valueOf((Boolean)state.method_11654((class_2769)BACKWARDS) == false));
        if (ControllerRailBlock.isStableWith(testState, (class_1922)world, pos)) {
            this.placeAndNotify(testState, pos, world);
        }
        return class_1269.field_5812;
    }

    private void placeAndNotify(class_2680 state, class_2338 pos, class_1937 world) {
        world.method_8652(pos, state, 3);
        world.method_8452(pos.method_10074(), (class_2248)this, null);
        if (((class_2768)state.method_11654(SHAPE)).method_11897()) {
            world.method_8452(pos.method_10084(), (class_2248)this, null);
        }
    }

    @Nullable
    private class_2338 findNextRail(class_2338 from, class_1922 world, boolean reversed) {
        class_2680 current = world.method_8320(from);
        if (!(current.method_26204() instanceof ControllerRailBlock)) {
            return null;
        }
        class_2382 accelerationVec = ControllerRailBlock.getAccelerationVector(current);
        class_2338 baseTestPos = reversed ? from.method_10059(accelerationVec) : from.method_10081(accelerationVec);
        for (class_2338 testPos : Iterate.hereBelowAndAbove(baseTestPos)) {
            class_2680 testState;
            if (testPos.method_10264() > from.method_10264() && !((class_2768)current.method_11654(SHAPE)).method_11897() || !((testState = world.method_8320(testPos)).method_26204() instanceof ControllerRailBlock) || !ControllerRailBlock.getAccelerationVector(testState).equals((Object)accelerationVec)) continue;
            return testPos;
        }
        return null;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)POWER);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        if (rotation == class_2470.field_11467) {
            return state;
        }
        class_2768 railshape = (class_2768)((class_2680)class_2246.field_10425.method_9564().method_11657(SHAPE, (Comparable)((class_2768)state.method_11654(SHAPE)))).method_26186(rotation).method_11654(SHAPE);
        state = (class_2680)state.method_11657(SHAPE, (Comparable)railshape);
        if (rotation == class_2470.field_11464 || ControllerRailBlock.getPointingTowards(state).method_10166() == class_2350.class_2351.field_11051 == (rotation == class_2470.field_11465)) {
            return (class_2680)state.method_28493((class_2769)BACKWARDS);
        }
        return state;
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        if (mirror == class_2415.field_11302) {
            return state;
        }
        class_2768 railshape = (class_2768)((class_2680)class_2246.field_10425.method_9564().method_11657(SHAPE, (Comparable)((class_2768)state.method_11654(SHAPE)))).method_26185(mirror).method_11654(SHAPE);
        if (ControllerRailBlock.getPointingTowards(state = (class_2680)state.method_11657(SHAPE, (Comparable)railshape)).method_10166() == class_2350.class_2351.field_11051 == (mirror == class_2415.field_11300)) {
            return (class_2680)state.method_28493((class_2769)BACKWARDS);
        }
        return state;
    }

    public static boolean isStateBackwards(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)BACKWARDS) ^ ControllerRailBlock.isReversedSlope(state);
    }

    public static boolean isReversedSlope(class_2680 state) {
        return state.method_11654(SHAPE) == class_2768.field_12668 || state.method_11654(SHAPE) == class_2768.field_12667;
    }

    protected MapCodec<? extends class_2241> method_53969() {
        return CODEC;
    }
}

