/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.kinetics.clock;

import com.mojang.serialization.Codec;
import com.zurrtum.create.AllAdvancements;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlock;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3542;

public class CuckooClockBlockEntity
extends KineticBlockEntity {
    public LerpedFloat animationProgress = LerpedFloat.linear();
    public Animation animationType = Animation.NONE;
    private boolean sendAnimationUpdate;

    public CuckooClockBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CUCKOO_CLOCK, pos, state);
    }

    @Override
    public List<CreateTrigger> getAwardables() {
        return List.of(AllAdvancements.CUCKOO_CLOCK);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket) {
            view.method_71426("Animation", Animation.CODEC).ifPresent(animation -> {
                this.animationType = animation;
                this.animationProgress.startWithValue(0.0);
            });
        }
    }

    @Override
    public void write(class_11372 view, boolean clientPacket) {
        if (clientPacket && this.sendAnimationUpdate) {
            view.method_71468("Animation", Animation.CODEC, (Object)this.animationType);
        }
        this.sendAnimationUpdate = false;
        super.write(view, clientPacket);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.field_11863.field_9236 || this.getSpeed() == 0.0f) {
            return;
        }
        boolean isNatural = this.field_11863.method_8597().comp_645();
        if (!isNatural) {
            return;
        }
        if (this.animationType == Animation.NONE) {
            int dayTime = (int)(this.field_11863.method_8532() % 24000L);
            int hours = (dayTime / 1000 + 6) % 24;
            int minutes = dayTime % 1000 * 60 / 1000;
            if (hours == 12 && minutes < 5) {
                this.startAnimation(Animation.PIG);
            }
            if (hours == 18 && minutes < 36 && minutes > 31) {
                this.startAnimation(Animation.CREEPER);
            }
        } else {
            float value = this.getAndIncrementProgress();
            if (value > 100.0f) {
                this.animationType = Animation.NONE;
            }
            if (this.animationType == Animation.SURPRISE && class_3532.method_15347((float)this.animationProgress.getValue(), (float)50.0f)) {
                class_243 center = VecHelper.getCenterOf((class_2382)this.field_11867);
                this.field_11863.method_22352(this.field_11867, false);
                this.field_11863.method_55117(null, AllDamageSources.get((class_1937)this.field_11863).cuckoo_surprise, null, center.field_1352, center.field_1351, center.field_1350, 3.0f, false, class_1937.class_7867.field_40889);
            }
        }
    }

    public float getAndIncrementProgress() {
        float value = this.animationProgress.getValue();
        this.animationProgress.setValue(value + 1.0f);
        return value;
    }

    public void startAnimation(Animation animation) {
        this.animationType = animation;
        if (animation != null && CuckooClockBlock.containsSurprise(this.method_11010())) {
            this.animationType = Animation.SURPRISE;
        }
        this.animationProgress.startWithValue(0.0);
        this.sendAnimationUpdate = true;
        if (animation == Animation.CREEPER) {
            this.awardIfNear(AllAdvancements.CUCKOO_CLOCK, 32);
        }
        this.sendData();
    }

    public static enum Animation implements class_3542
    {
        PIG,
        CREEPER,
        SURPRISE,
        NONE;

        public static final Codec<Animation> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(Animation::values);
        }
    }
}

