/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.content.fluids.potion;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllItemTags;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.infrastructure.component.BottleType;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_124;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_9334;

public class PotionFluidHandler {
    private static final class_2561 NO_EFFECT = class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080);

    public static boolean isPotionItem(class_1799 stack) {
        return stack.method_7909() instanceof class_1812 && !(stack.method_7909().method_7858().method_7909() instanceof class_1755) && !stack.method_31573(AllItemTags.NOT_POTION);
    }

    public static Pair<FluidStack, class_1799> emptyPotion(class_1799 stack, boolean simulate) {
        FluidStack fluid = PotionFluidHandler.getFluidFromPotionItem(stack);
        if (!simulate) {
            stack.method_7934(1);
        }
        return Pair.of(fluid, new class_1799((class_1935)class_1802.field_8469));
    }

    public static FluidStack getFluidFromPotionItem(class_1799 stack) {
        class_1844 potion = (class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
        BottleType bottleTypeFromItem = PotionFluidHandler.bottleTypeFromItem(stack.method_7909());
        if (potion.method_57401(class_1847.field_8991) && potion.comp_2380().isEmpty() && bottleTypeFromItem == BottleType.REGULAR) {
            return new FluidStack((class_3611)class_3612.field_15910, 27000);
        }
        FluidStack fluid = PotionFluidHandler.getFluidFromPotion(potion, bottleTypeFromItem, 27000);
        fluid.set(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, bottleTypeFromItem);
        return fluid;
    }

    public static FluidStack getFluidFromPotion(class_1844 potionContents, BottleType bottleType, int amount) {
        if (potionContents.method_57401(class_1847.field_8991) && bottleType == BottleType.REGULAR) {
            return new FluidStack((class_3611)class_3612.field_15910, amount);
        }
        return PotionFluidHandler.getFluidStack(amount, potionContents, bottleType);
    }

    public static FluidStack getFluidStack(int amount, class_1844 potionContents, BottleType bottleType) {
        FluidStack fluidStack = new FluidStack((class_3611)AllFluids.POTION, amount);
        PotionFluidHandler.addPotionToFluidStack(fluidStack, potionContents);
        fluidStack.set(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, bottleType);
        return fluidStack;
    }

    public static void addPotionToFluidStack(FluidStack fs, class_1844 potionContents) {
        if (potionContents == class_1844.field_49274) {
            fs.remove(class_9334.field_49651);
            return;
        }
        fs.set(class_9334.field_49651, potionContents);
    }

    public static BottleType bottleTypeFromItem(class_1792 item) {
        if (item == class_1802.field_8150) {
            return BottleType.LINGERING;
        }
        if (item == class_1802.field_8436) {
            return BottleType.SPLASH;
        }
        return BottleType.REGULAR;
    }

    public static class_1792 itemFromBottleType(BottleType type) {
        return switch (type) {
            case BottleType.LINGERING -> class_1802.field_8150;
            case BottleType.SPLASH -> class_1802.field_8436;
            default -> class_1802.field_8574;
        };
    }

    public static int getRequiredAmountForFilledBottle(class_1799 stack, FluidStack availableFluid) {
        return 27000;
    }

    public static class_1799 fillBottle(class_1799 stack, FluidStack availableFluid) {
        class_1799 potionStack = new class_1799((class_1935)PotionFluidHandler.itemFromBottleType((BottleType)((Object)availableFluid.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)BottleType.REGULAR))));
        potionStack.method_57379(class_9334.field_49651, (Object)((class_1844)availableFluid.method_58694(class_9334.field_49651)));
        return potionStack;
    }
}

