/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.client.flywheel.lib.model.baked.BakedItemModelBufferer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;

@Environment(value=EnvType.CLIENT)
public class ItemChunkLayerSortedListBuilder<T> {
    private static final ThreadLocal<ItemChunkLayerSortedListBuilder<?>> THREAD_LOCAL = ThreadLocal.withInitial(ItemChunkLayerSortedListBuilder::new);
    private final List<ObjectArrayList<T>> lists;

    private ItemChunkLayerSortedListBuilder() {
        int size = BakedItemModelBufferer.getChunkLayers().size();
        this.lists = new ArrayList<ObjectArrayList<T>>(size);
        for (int layerIndex = 0; layerIndex < size; ++layerIndex) {
            this.lists.add(new ObjectArrayList());
        }
    }

    public static <T> ItemChunkLayerSortedListBuilder<T> getThreadLocal() {
        return THREAD_LOCAL.get();
    }

    public void add(class_1921 renderType, T obj) {
        Integer layerIndex = BakedItemModelBufferer.getChunkLayers().get(renderType);
        if (layerIndex == null) {
            throw new IllegalArgumentException("RenderType '" + String.valueOf(renderType) + "' is not a chunk layer");
        }
        int size = this.lists.size();
        if (size > layerIndex) {
            this.lists.get(layerIndex).add(obj);
            return;
        }
        while (size < layerIndex) {
            this.lists.add(new ObjectArrayList());
            ++size;
        }
        ObjectArrayList list = new ObjectArrayList();
        list.add(obj);
        this.lists.add(list);
    }

    public ImmutableList<T> build() {
        int size = 0;
        for (ObjectArrayList<T> list : this.lists) {
            size += list.size();
        }
        Object[] array = new Object[size];
        int destPos = 0;
        for (ObjectArrayList<T> list : this.lists) {
            System.arraycopy(list.elements(), 0, array, destPos, list.size());
            destPos += list.size();
            list.clear();
        }
        return ImmutableList.copyOf((Object[])array);
    }
}

