/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v4;

import fuzs.puzzleslib.api.network.v4.NetworkingHelper;
import fuzs.puzzleslib.api.network.v4.PlayerSet;
import fuzs.puzzleslib.api.network.v4.message.Message;
import fuzs.puzzleslib.api.util.v1.EntityHelper;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3222;
import net.minecraft.class_8705;
import net.minecraft.class_8706;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;

public final class MessageSender {
    private MessageSender() {
    }

    public static void broadcast(Message<? extends Message.Context<? extends class_8706>> message) {
        Objects.requireNonNull(message, "message is null");
        MessageSender.broadcast(message);
    }

    @ApiStatus.Experimental
    public static void broadcast(class_8710 payload) {
        Objects.requireNonNull(payload, "payload is null");
        if (NetworkingHelper.hasChannel((class_2547)NetworkingHelper.getClientPacketListener(), payload.method_56479())) {
            MessageSender.broadcast(NetworkingHelper.toServerboundPacket(payload));
        }
    }

    public static void broadcast(class_2596<?> packet) {
        Objects.requireNonNull(packet, "packet is null");
        class_2602 packetListener = NetworkingHelper.getClientPacketListener();
        class_2535 connection = NetworkingHelper.getConnection((class_2547)packetListener);
        connection.method_10743(packet);
    }

    public static void broadcast(PlayerSet playerSet, Message<? extends Message.Context<? extends class_8705>> message) {
        Objects.requireNonNull(playerSet, "player set is null");
        Objects.requireNonNull(message, "message is null");
        MessageSender.broadcast(playerSet, message);
    }

    @ApiStatus.Experimental
    public static void broadcast(PlayerSet playerSet, class_8710 payload) {
        Objects.requireNonNull(playerSet, "player set is null");
        Objects.requireNonNull(payload, "payload is null");
        MessageSender.broadcast((Consumer<class_3222> serverPlayerConsumer) -> playerSet.apply(serverPlayer -> {
            if (NetworkingHelper.hasChannel((class_2547)serverPlayer.field_13987, payload.method_56479())) {
                serverPlayerConsumer.accept(serverPlayer);
            }
        }), NetworkingHelper.toClientboundPacket(payload));
    }

    public static void broadcast(PlayerSet playerSet, class_2596<?> packet) {
        Objects.requireNonNull(playerSet, "player set is null");
        Objects.requireNonNull(packet, "packet is null");
        playerSet.apply(serverPlayer -> {
            if (!EntityHelper.isFakePlayer(serverPlayer)) {
                serverPlayer.field_13987.method_14364(packet);
            }
        });
    }
}

