/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.impl.client.search.argument.type.AlwaysMatchingArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.IdentifierArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.ModArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.RegexArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.TagArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.TextArgumentType;
import me.shedaniel.rei.impl.client.search.argument.type.TooltipArgumentType;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ArgumentTypesRegistry {
    public static final Map<String, ArgumentType<?, ?>> ARGUMENT_TYPES = Maps.newHashMap();
    public static final List<ArgumentType<?, ?>> ARGUMENT_TYPE_LIST = Lists.newArrayList();

    private static void register(ArgumentType<?, ?> argumentType) {
        ARGUMENT_TYPES.put(argumentType.getName(), argumentType);
        ARGUMENT_TYPE_LIST.add(argumentType);
    }

    static {
        ArgumentTypesRegistry.register(new AlwaysMatchingArgumentType());
        ArgumentTypesRegistry.register(new ModArgumentType());
        ArgumentTypesRegistry.register(new TooltipArgumentType());
        ArgumentTypesRegistry.register(new TagArgumentType());
        ArgumentTypesRegistry.register(new IdentifierArgumentType());
        ArgumentTypesRegistry.register(new RegexArgumentType());
        ArgumentTypesRegistry.register(new TextArgumentType());
    }
}

