/*
 * Decompiled with CFR 0.152.
 */
package com.nenio.enchant;

import com.nenio.config.ConfigManager;
import com.nenio.enchant.CollectorEffectHandler;
import com.nenio.enchant.GridEffectHandler;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public final class AutosowEffectHandler {
    private static final class_5321<class_1887> AUTOSOW_KEY = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)class_2960.method_60655((String)"farmerenchants", (String)"autosow"));
    private static final class_5321<class_1887> FORTUNE_KEY = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)class_2960.method_60655((String)"minecraft", (String)"fortune"));
    private static final class_5321<class_1887> FERTILITY_KEY = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)class_2960.method_60655((String)"farmerenchants", (String)"fertility"));
    private static final String FORTUNE_APPLIED_TAG = "fe_fortune_applied";
    private static final Int2LongOpenHashMap FE_SEEN = new Int2LongOpenHashMap();
    private static final ThreadLocal<Boolean> REPLANTING = ThreadLocal.withInitial(() -> false);

    private AutosowEffectHandler() {
    }

    private static int getFertilityLevel(class_1937 world, class_1799 tool) {
        class_5455 regs = world.method_30349();
        class_2378 ench = regs.method_30530(class_7924.field_41265);
        class_6880.class_6883 fertility = ench.method_46746(FERTILITY_KEY).orElse(null);
        if (fertility == null) {
            return 0;
        }
        class_9304 comp = (class_9304)tool.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        return comp.method_57536((class_6880)fertility);
    }

    public static void register() {
        PlayerBlockBreakEvents.AFTER.register(AutosowEffectHandler::afterBreak);
        UseBlockCallback.EVENT.register(AutosowEffectHandler::onUseBlock);
    }

    private static void afterBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 be) {
        if (world.method_8608()) {
            return;
        }
        if (!ConfigManager.get().autosow.enable) {
            return;
        }
        if (Boolean.TRUE.equals(REPLANTING.get())) {
            return;
        }
        if (!AutosowEffectHandler.isHoeWithAutosow(player, world)) {
            return;
        }
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof class_2302)) {
            return;
        }
        class_2302 crop = (class_2302)class_22482;
        if (!crop.method_9825(state)) {
            return;
        }
        if (!world.method_8320(pos.method_10074()).method_27852(class_2246.field_10362)) {
            return;
        }
        class_1792 seedItem = AutosowEffectHandler.resolveSeedItem(state);
        if (seedItem == null) {
            return;
        }
        class_1799 toolSnapshot = player.method_6047().method_7972();
        world.method_8503().execute(() -> GridEffectHandler.forEach(world, pos, toolSnapshot, p -> {
            class_1792 seedItem2;
            class_2680 s = world.method_8320(p);
            boolean isCenter = p.equals((Object)pos);
            class_2248 patt0$temp = s.method_26204();
            if (!(patt0$temp instanceof class_2302)) {
                return;
            }
            class_2302 crop2 = (class_2302)patt0$temp;
            if (!world.method_8320(p.method_10074()).method_27852(class_2246.field_10362)) {
                return;
            }
            if (!isCenter) {
                if (!crop2.method_9825(s)) {
                    return;
                }
                REPLANTING.set(true);
                try {
                    world.method_8651(p, true, (class_1297)player);
                }
                finally {
                    REPLANTING.set(false);
                }
            }
            if ((seedItem2 = AutosowEffectHandler.resolveSeedItem(s)) == null) {
                return;
            }
            boolean invOnly2 = ConfigManager.get().autosow.requireSeeds;
            if (!AutosowEffectHandler.consumeSeed(world, p, seedItem2, player, invOnly2)) {
                return;
            }
            if (ConfigManager.get().autosow.enableFortuneMultiplier) {
                AutosowEffectHandler.applyFortuneMultiplier(world, p, s, toolSnapshot);
            }
            if (ConfigManager.get().collector.enable) {
                CollectorEffectHandler.scheduleCollect(world, p, player);
            }
            int replAge2 = 0;
            if (ConfigManager.get().fertility.enable) {
                int fert = AutosowEffectHandler.getFertilityLevel(world, toolSnapshot);
                replAge2 = Math.max(0, Math.min(fert, crop2.method_9827() - 1));
            }
            world.method_8652(p, crop2.method_9828(replAge2), 3);
        }));
    }

    private static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        if (world.method_8608()) {
            return class_1269.field_5811;
        }
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 tool = player.method_6047();
        if (!(tool.method_7909() instanceof class_1794)) {
            return class_1269.field_5811;
        }
        boolean hasAutosow = AutosowEffectHandler.isHoeWithAutosow(player, world);
        int gridLevel = GridEffectHandler.getGridLevel(world, tool);
        if (!hasAutosow && gridLevel <= 0) {
            return class_1269.field_5811;
        }
        boolean[] didAnything = new boolean[]{false};
        GridEffectHandler.forEach(world, hit.method_17777(), tool, pos -> {
            class_2302 crop;
            class_2248 patt0$temp;
            class_2680 state = world.method_8320(pos);
            if (hasAutosow && (patt0$temp = state.method_26204()) instanceof class_2302 && (crop = (class_2302)patt0$temp).method_9825(state) && world.method_8320(pos.method_10074()).method_27852(class_2246.field_10362)) {
                class_1792 seedItem = AutosowEffectHandler.resolveSeedItem(state);
                if (seedItem == null) {
                    return;
                }
                try {
                    REPLANTING.set(true);
                    world.method_8651(pos, true, (class_1297)player);
                    boolean invOnly = ConfigManager.get().autosow.requireSeeds;
                    if (!AutosowEffectHandler.consumeSeed(world, pos, seedItem, player, invOnly)) {
                        return;
                    }
                    if (ConfigManager.get().autosow.enableFortuneMultiplier) {
                        AutosowEffectHandler.applyFortuneMultiplier(world, pos, state, tool);
                    }
                    if (ConfigManager.get().collector.enable) {
                        CollectorEffectHandler.collectNow(world, pos, player);
                    }
                    int replAge = 0;
                    if (ConfigManager.get().fertility.enable) {
                        int fertLevel = AutosowEffectHandler.getFertilityLevel(world, tool);
                        replAge = Math.max(0, Math.min(fertLevel, crop.method_9827() - 1));
                    }
                    world.method_8652(pos, crop.method_9828(replAge), 3);
                    if (!player.method_31549().field_7477 && tool.method_7963()) {
                        tool.method_7970(1, (class_1309)player, class_1304.field_6173);
                    }
                    didAnything[0] = true;
                }
                finally {
                    REPLANTING.set(false);
                }
            }
        });
        return didAnything[0] ? class_1269.field_5812 : class_1269.field_5811;
    }

    private static boolean isHoeWithAutosow(class_1657 player, class_1937 world) {
        class_1799 tool = player.method_6047();
        if (!(tool.method_7909() instanceof class_1794)) {
            return false;
        }
        class_5455 regs = world.method_30349();
        class_2378 ench = regs.method_30530(class_7924.field_41265);
        class_6880 autosow = ench.method_46746(AUTOSOW_KEY).orElse(null);
        if (autosow == null) {
            return false;
        }
        class_9304 comp = (class_9304)tool.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        return comp.method_57536(autosow) > 0;
    }

    private static boolean consumeSeed(class_1937 world, class_2338 pos, class_1792 seedItem, class_1657 player, boolean invOnly) {
        if (player.method_31549().field_7477) {
            return true;
        }
        if (invOnly) {
            return AutosowEffectHandler.consumeOneFromInventory(player, seedItem);
        }
        if (AutosowEffectHandler.takeOneFromFreshDrops(world, pos, seedItem)) {
            return true;
        }
        return AutosowEffectHandler.consumeOneFromInventory(player, seedItem);
    }

    private static boolean takeOneFromFreshDrops(class_1937 world, class_2338 pos, class_1792 item) {
        class_238 box = new class_238(pos).method_1014(1.25);
        for (class_1542 ent : world.method_18467(class_1542.class, box)) {
            class_1799 stack;
            if (ent.method_6985() > 40 || !(stack = ent.method_6983()).method_31574(item)) continue;
            stack.method_7934(1);
            if (stack.method_7960()) {
                ent.method_31472();
            } else {
                ent.method_6979(stack);
            }
            return true;
        }
        return false;
    }

    private static void applyFortuneMultiplier(class_1937 world, class_2338 pos, class_2680 state, class_1799 tool) {
        int max;
        int min;
        int fortune = AutosowEffectHandler.getFortuneLevel(world, tool);
        if (fortune <= 0) {
            return;
        }
        if (fortune == 1) {
            min = 1;
            max = 2;
        } else if (fortune == 2) {
            min = 1;
            max = 3;
        } else {
            min = 2;
            max = 3;
        }
        int factor = min + world.method_8409().method_43048(max - min + 1);
        if (factor <= 1) {
            return;
        }
        class_1792 produce = AutosowEffectHandler.resolveProduceItem(state);
        if (produce == null) {
            return;
        }
        class_238 box = new class_238(pos).method_1014(0.75);
        int FRESH_TICKS = 12;
        for (class_1542 ent : world.method_18467(class_1542.class, box)) {
            int take;
            class_1799 stack;
            class_1542 e;
            if (ent.method_6985() > 12 || (e = ent).method_5752().contains(FORTUNE_APPLIED_TAG) || !(stack = ent.method_6983()).method_31574(produce)) continue;
            int total = stack.method_7947() * factor;
            int maxStack = stack.method_7914();
            stack.method_7939(Math.min(maxStack, total));
            ent.method_6979(stack);
            e.method_5780(FORTUNE_APPLIED_TAG);
            for (int left = total - stack.method_7947(); left > 0; left -= take) {
                take = Math.min(maxStack, left);
                class_1542 more = new class_1542(world, ent.method_23317(), ent.method_23318(), ent.method_23321(), new class_1799((class_1935)produce, take));
                more.method_5780(FORTUNE_APPLIED_TAG);
                world.method_8649((class_1297)more);
            }
        }
    }

    private static int getFortuneLevel(class_1937 world, class_1799 tool) {
        class_5455 regs = world.method_30349();
        class_2378 ench = regs.method_30530(class_7924.field_41265);
        class_6880 fortune = ench.method_46746(FORTUNE_KEY).orElse(null);
        if (fortune == null) {
            return 0;
        }
        class_9304 comp = (class_9304)tool.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        return comp.method_57536(fortune);
    }

    @Nullable
    private static class_1792 resolveSeedItem(class_2680 state) {
        class_2248 b = state.method_26204();
        if (b == class_2246.field_10293) {
            return class_1802.field_8317;
        }
        if (b == class_2246.field_10341) {
            return class_1802.field_8309;
        }
        if (b == class_2246.field_10609) {
            return class_1802.field_8179;
        }
        if (b == class_2246.field_10247) {
            return class_1802.field_8567;
        }
        if (b == class_2246.field_42749) {
            return class_1802.field_42711;
        }
        if (b == class_2246.field_43228) {
            return class_1802.field_43195;
        }
        return null;
    }

    @Nullable
    private static class_1792 resolveProduceItem(class_2680 state) {
        class_2248 b = state.method_26204();
        if (b == class_2246.field_10293) {
            return class_1802.field_8861;
        }
        if (b == class_2246.field_10341) {
            return class_1802.field_8186;
        }
        if (b == class_2246.field_10609) {
            return class_1802.field_8179;
        }
        if (b == class_2246.field_10247) {
            return class_1802.field_8567;
        }
        return null;
    }

    private static boolean consumeOneFromInventory(class_1657 player, class_1792 item) {
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 st = inv.method_5438(i);
            if (st.method_7960() || !st.method_31574(item)) continue;
            st.method_7934(1);
            if (st.method_7960()) {
                inv.method_5447(i, class_1799.field_8037);
            }
            return true;
        }
        return false;
    }
}

