/*
 * Decompiled with CFR 0.152.
 */
package com.jtorleonstudios.libraryferret.worldgen.structures;

import com.jtorleonstudios.libraryferret.LibraryFerret;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function8;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_8891;
import net.minecraft.class_9778;
import net.minecraft.class_9822;
import org.jetbrains.annotations.NotNull;

public abstract class AwesomeStructure
extends class_3195 {
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final class_6122 startHeight;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final String uniqueIdentifier;
    private final class_9778 dimensionPadding;
    private final class_9822 liquidSettings;

    public AwesomeStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, String uniqueIdentifier, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, class_9778 dimensionPadding, class_9822 liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.uniqueIdentifier = uniqueIdentifier;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    public static <T extends AwesomeStructure> Codec<T> getDefaultCodec(int size, int maxDistanceFromCenter, Function<String, Boolean> bindEnabledFromConfiguration, Function8<class_3195.class_7302, class_6880<class_3785>, String, Optional<class_2960>, Integer, class_6122, Optional<class_2902.class_2903>, Integer, T> structureCreator) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)AwesomeStructure.method_42697((RecordCodecBuilder.Instance)i), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(AwesomeStructure::startPool), (App)Codec.STRING.optionalFieldOf("unique_identifier", (Object)"").forGetter(AwesomeStructure::uniqueIdentifier), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(AwesomeStructure::startJigsawName), (App)Codec.intRange((int)0, (int)(size + 1)).fieldOf("size").forGetter(AwesomeStructure::size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(AwesomeStructure::startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(AwesomeStructure::projectStartToHeightmap), (App)Codec.intRange((int)1, (int)maxDistanceFromCenter).fieldOf("max_distance_from_center").forGetter(AwesomeStructure::maxDistanceFromCenter)).apply((Applicative)i, (_config, _startPool, _uniqueIdentifier, _startJigsawName, _size, _startHeight, _projectStartToHeightmap, _maxDistanceFromCenter) -> (AwesomeStructure)((Object)((Object)((Object)structureCreator.apply((Object)new class_3195.class_7302((Boolean)bindEnabledFromConfiguration.apply((String)_uniqueIdentifier) != false ? _config.comp_686() : AwesomeStructure.onDisabledStructure(_uniqueIdentifier), _config.comp_687(), _config.comp_688(), _config.comp_689()), _startPool, _uniqueIdentifier, _startJigsawName, _size, _startHeight, _projectStartToHeightmap, _maxDistanceFromCenter)))))).codec();
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 ctx) {
        if (!this.canGenerate(ctx)) {
            return Optional.empty();
        }
        return class_3778.method_30419((class_3195.class_7149)ctx, this.startPool, this.startJigsawName, (int)this.size, (class_2338)this.getInitialStartPosition(ctx), (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (class_8891)class_8891.field_46826, (class_9778)this.dimensionPadding, (class_9822)this.liquidSettings);
    }

    protected class_2338 getInitialStartPosition(class_3195.class_7149 ctx) {
        return ctx.comp_568().method_33943(0);
    }

    protected abstract boolean canGenerate(class_3195.class_7149 var1);

    private static class_6885<class_1959> onDisabledStructure(String _uniqueIdentifier) {
        LibraryFerret.LOGGER.info("structure disabled: " + _uniqueIdentifier);
        return class_6885.method_40246((class_6880[])new class_6880[0]);
    }

    public static boolean isValidStructureBiome(@NotNull class_3195.class_7149 ctx, int biomeRange) {
        if (!(ctx.comp_563() instanceof class_1973)) {
            class_1923 chunkPos = ctx.comp_568();
            for (int curChunkX = chunkPos.field_9181 - biomeRange; curChunkX <= chunkPos.field_9181 + biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - biomeRange; curChunkZ <= chunkPos.field_9180 + biomeRange; ++curChunkZ) {
                    class_6880 biome = ctx.comp_563().method_38109(curChunkX << 2, 16, curChunkZ << 2, ctx.comp_564().method_42371());
                    if (ctx.comp_570().test(biome)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isEmptyFluidState(@NotNull class_3195.class_7149 ctx, @NotNull class_2338 position, class_2902.class_2903 projectStartToHeightmap) {
        return ctx.comp_562().method_26261(position.method_10263(), position.method_10260(), ctx.comp_569(), ctx.comp_564()).method_32892(ctx.comp_562().method_18028(position.method_10263(), position.method_10260(), projectStartToHeightmap, ctx.comp_569(), ctx.comp_564())).method_26227().method_15769();
    }

    private String uniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    public final class_6880<class_3785> startPool() {
        return this.startPool;
    }

    public final Optional<class_2960> startJigsawName() {
        return this.startJigsawName;
    }

    public final int size() {
        return this.size;
    }

    public final class_6122 startHeight() {
        return this.startHeight;
    }

    public final Optional<class_2902.class_2903> projectStartToHeightmap() {
        return this.projectStartToHeightmap;
    }

    public final int maxDistanceFromCenter() {
        return this.maxDistanceFromCenter;
    }
}

