/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.math.blendingfunction;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.core.CorgiLibRegistry;
import corgitaco.corgilib.math.blendingfunction.BlendingFunctions;
import corgitaco.corgilib.platform.ModPlatform;

public interface BlendingFunction {
    public static final Codec<BlendingFunction> CODEC = Codec.lazyInitialized(() -> CorgiLibRegistry.BLENDING_FUNCTION.get().method_39673().dispatchStable(BlendingFunction::codec, MapCodec::assumeMapUnsafe));

    public Codec<? extends BlendingFunction> codec();

    public double apply(double var1);

    default public double apply(double factor, double min, double max) {
        double range = max - min;
        return min + range * this.apply(factor);
    }

    public static void register() {
        BlendingFunction.register("ease_in_out_circ", EaseInOutCirc.CODEC);
        BlendingFunction.register("ease_out_bounce", EaseOutBounce.CODEC);
        BlendingFunction.register("ease_out_cubic", EaseOutCubic.CODEC);
        BlendingFunction.register("ease_out_elastic", EaseOutElastic.CODEC);
        BlendingFunction.register("ease_in_circ", EaseInCirc.CODEC);
        BlendingFunction.register("ease_out_quint", EaseOutQuint.CODEC);
    }

    private static void register(String name, Codec<? extends BlendingFunction> function) {
        ModPlatform.PLATFORM.register(CorgiLibRegistry.BLENDING_FUNCTION.get(), name, () -> function);
    }

    public record EaseInOutCirc() implements BlendingFunction
    {
        public static final EaseInOutCirc INSTANCE = new EaseInOutCirc();
        public static final Codec<EaseInOutCirc> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeInOutCirc(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseOutBounce() implements BlendingFunction
    {
        public static final EaseOutBounce INSTANCE = new EaseOutBounce();
        public static final Codec<EaseOutBounce> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeOutBounce(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseOutCubic() implements BlendingFunction
    {
        public static final EaseOutCubic INSTANCE = new EaseOutCubic();
        public static final Codec<EaseOutCubic> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeOutCubic(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseOutElastic(double intensity) implements BlendingFunction
    {
        public static final EaseOutElastic INSTANCE = new EaseOutElastic(10.0);
        public static final Codec<EaseOutElastic> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.DOUBLE.fieldOf("intensity").forGetter(EaseOutElastic::intensity)).apply((Applicative)builder, EaseOutElastic::new));

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeOutElastic(factor, this.intensity);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseInCirc(double exponent) implements BlendingFunction
    {
        public static final EaseInCirc INSTANCE = new EaseInCirc(2.0);
        public static final Codec<EaseInCirc> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("exponent").forGetter(EaseInCirc::exponent)).apply((Applicative)instance, EaseInCirc::new));

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeInCirc(factor, this.exponent);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }

    public record EaseOutQuint() implements BlendingFunction
    {
        public static final EaseOutQuint INSTANCE = new EaseOutQuint();
        public static final Codec<EaseOutQuint> CODEC = Codec.unit(() -> INSTANCE);

        @Override
        public double apply(double factor) {
            return BlendingFunctions.easeOutQuint(factor);
        }

        @Override
        public Codec<? extends BlendingFunction> codec() {
            return CODEC;
        }
    }
}

